/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui;

import java.util.Optional;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.designation.TileDesignation;
import technology.rocketjump.undermount.mapping.tile.designation.TileDesignationDictionary;
import technology.rocketjump.undermount.rooms.RoomType;

public enum GameInteractionMode {
    DEFAULT(null, null, null, false),
    DESIGNATE_MINING("mining", "MINING", mapTile -> mapTile.hasWall() && mapTile.getDesignation() == null, true),
    DESIGNATE_CHOP_WOOD("logging", "CHOP_WOOD", mapTile -> mapTile.hasTree() && mapTile.getDesignation() == null, true),
    DESIGNATE_HARVEST_PLANTS("sickle", "HARVEST", mapTile -> {
        if (mapTile.getDesignation() != null) {
            return false;
        }
        if (mapTile.hasShrub()) {
            Optional<Entity> first = mapTile.getEntities().stream().filter(e -> e.getType().equals((Object)EntityType.PLANT)).filter(e -> ((PlantEntityAttributes)e.getPhysicalEntityComponent().getAttributes()).getSpecies().hasFruit()).findFirst();
            if (first.isPresent()) {
                PlantEntityAttributes attributes = (PlantEntityAttributes)first.get().getPhysicalEntityComponent().getAttributes();
                return attributes.getFruitState().equals((Object)PlantEntityAttributes.FruitState.RIPE);
            }
            return false;
        }
        return false;
    }, true),
    DESIGNATE_CLEAR_GROUND("spade", "CLEAR_GROUND", mapTile -> mapTile.hasShrub() && mapTile.getDesignation() == null, true),
    REMOVE_DESIGNATIONS("cancel", null, mapTile -> mapTile.getDesignation() != null, true),
    PLACE_ROOM("rooms", null, mapTile -> !mapTile.hasWall() && !mapTile.hasRoom() && !mapTile.hasDoorway(), true),
    PLACE_FURNITURE("zones", null, null, false),
    PLACE_DOOR("door", null, null, false),
    REMOVE_ROOMS("cancel", "REMOVE_ROOMS", mapTile -> mapTile.hasRoom(), true);

    public final String cursorName;
    public final String designationName;
    private TileDesignation designationToApply;
    public final DesignationCheck designationCheck;
    private RoomType roomType;
    private FurnitureType furnitureType;
    public final boolean isDraggable;

    private GameInteractionMode(String cursorName, String designationName, DesignationCheck designationCheck, boolean isDraggable) {
        this.cursorName = cursorName;
        this.designationName = designationName;
        this.designationCheck = designationCheck;
        this.isDraggable = isDraggable;
    }

    public static void init(TileDesignationDictionary designationDictionary) {
        for (GameInteractionMode interactionMode : GameInteractionMode.values()) {
            if (interactionMode.designationName == null) continue;
            TileDesignation designation = designationDictionary.getByName(interactionMode.designationName);
            if (designation == null) {
                throw new RuntimeException("No designation found by name: " + interactionMode.designationName);
            }
            interactionMode.designationToApply = designation;
        }
        GameInteractionMode.PLACE_ROOM.roomType = new RoomType();
    }

    public TileDesignation getDesignationToApply() {
        return this.designationToApply;
    }

    public boolean isDesignation() {
        return REMOVE_DESIGNATIONS.equals((Object)this) || this.designationName != null;
    }

    public RoomType getRoomType() {
        return this.roomType;
    }

    public void setRoomType(RoomType roomType) {
        this.roomType = roomType;
    }

    public void setFurnitureType(FurnitureType furnitureType) {
        this.furnitureType = furnitureType;
    }

    public FurnitureType getFurnitureType() {
        return this.furnitureType;
    }

    public static interface DesignationCheck {
        public boolean shouldDesignationApply(MapTile var1);
    }
}

